CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{12124FA1-4E8A-4361-AE42-6AB4348A30D7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{2DFEFC6B-081A-4EE8-B4EA-E36558EAB195}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{ABE376E0-5E65-4103-A630-6CDD6B7BEBC7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{CB804F21-0528-48F2-A113-C2319F1C312A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{A922AED1-45C3-412C-8B1F-0A9CEFD262EA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{1DDE72E4-451D-4AAE-8119-F3A05AF8248D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{2915C5A0-6F99-4283-B337-A95D3B3537F4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{530A48C6-0001-40F4-8B3C-D5B11A77E4A3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{6E5DD161-2471-4A80-9BF0-32487B26A571}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{AA25C36E-1F14-4A2F-84DB-2E2DFC628551}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{13F58349-CEE0-4A6C-BF99-7D83C6D932BD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{E5568285-5BAA-450E-835C-DE5F73CDC12E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{4B00BE92-D639-4BD9-9D41-DB07E6EC7729}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{45BA2C54-0554-41C3-9BC4-118307B298F4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{E3C511D1-C1D7-4AE7-8773-7972526A02CF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{C23B10F8-0252-4B06-B51C-A461453099B4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{CEB67C80-0E2D-4BB5-B71B-0896F7969A80}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{3F1B6737-C6EF-4538-9975-0C6AFFA57568}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{778C30EF-7CF5-487B-B02E-FBBB0D5295B0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{84EAF754-49D5-40DD-9A24-FB9C900AF9AA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{585E1940-DC01-4A00-BE80-052877C9B1F9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{0D599F3F-D6FB-40A7-AF38-C37124053C2B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{6DF7C4E1-F738-4CF6-BDEC-F0396D567569}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{6C4D6D61-BBF9-4158-A444-9DB84904F421}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{2E0CD670-38F1-4E8D-ADC7-AF4F2FD28943}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{881FDC87-CDC2-4B4B-A60A-87C33AA55DC7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{DE6B0869-3EC9-4315-A530-152104E3154C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{E23EECB4-D0D1-4E79-BF35-E4552F01D277}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{126E97A3-B947-4C6A-A001-52BB7BA6FA44}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{D2B621B5-F4A9-4B0E-9215-5EA5D805B45F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{01FC8203-9B8C-472D-8124-13748166A0E1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{F18C6C29-DD8D-4497-9A09-EB139DB00F27}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{64D7F2D8-96C4-4BEB-B59D-80B822A671F6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{8C1F51C9-88D4-4C90-8D17-5BE1DAA20DEA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{F4FEB12F-2FD2-467C-9E17-878FF2D5E382}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{C1D2292E-FC66-4077-A007-70A89B2C8351}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{051465B7-584B-4472-B9CA-22DE89226DB4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{C5B5A2A9-B3E9-475E-BEDE-BBA1C0849CFF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{913AF536-C121-49BA-8327-0D1C9A021084}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{D48BB711-022F-4582-B6CE-26ABE82BE06C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{7833FE59-A4CE-48F6-8C17-6F3F499FCC70}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{31DA4A96-0957-4665-AC56-084A14722D76}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{9CB5202D-9D8C-43CB-BAC1-9BB4BA20DCD6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{0DF48421-4856-4A43-81AE-0538FFE69F79}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{37F92876-C37F-498D-8FA3-DC0B76F94B30}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{4E5965D6-6BD6-4BAF-82B2-160EC33BF5B3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{01560070-6068-4321-B538-AC2C88BF0636}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{D068409D-E84D-41B8-B28A-250BFF063DD7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{8574A897-852F-4754-8712-9C4F0238A19C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{342082E8-8C65-4050-B7C2-F7E1766262AC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{74847CFB-C26A-45C9-956A-605D842DB979}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{DD8490D3-DA21-4A3B-8907-FDB7CB503FF6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{F1863A83-E88B-48A5-B78B-9163EACD82D7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{17EA2DE7-EE60-4919-8E7B-4C47C29B3D54}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{A29F1047-A78F-4E81-9346-C6259AA88E0E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{0686798C-B809-41B6-AEA4-7F34B942ABA6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{E4956CE0-E963-45A1-A9BE-ED83A40BFF04}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{4EAF84AE-FF1E-422B-B445-32C9D0E2610B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{9F80AA4F-9008-4B86-B48D-1537E0EAD7FF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{466AF8CD-AF19-441E-AA3F-038CFEB6FA4C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{11CCD0DD-B99E-444E-BF90-FA4A7DAAD6CB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{4A87DCA1-2286-4939-B405-B681C4F26E5F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{880E3CC1-712B-4D2B-9A69-5E898376C53D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{C12EF598-309F-4186-8BEA-56479AB044C7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{3047B555-2E02-4226-B958-CFFA4CF98B15}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{A9C1412D-F768-4CB7-9601-A2E68487924B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{46D0F063-D567-453E-8924-A921B04DB3E4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{C629338E-027D-44F6-B5D5-B2C6A7C5FC32}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{BCDC981B-7F0F-4B86-A264-CEF5B661FE95}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{08ABF332-9A8C-4C71-B507-3D73F6A5E87D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{6BBB6C3E-40F8-4D7A-9181-269BCFEAFE09}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{30D82E87-59F8-4D7F-A06C-82BF3CD27A50}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{B2D923D5-10E3-4C4E-B0E2-750EEF81E034}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{A66EBACD-CD7F-4FFF-8BDD-E2BB2E050F88}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{C5D26BF7-2D38-4740-84E5-68754B36C41C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{1180A264-930C-4B65-AAAF-93B880BF1DB5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{63BA874F-4A39-40D4-8ECF-203E65532DA1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{0B71735B-67C1-49BF-8088-479AACF22526}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{96A119B4-7440-49F4-8920-2563D341FC7B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{F609B21F-A096-4EBC-8F43-93969541E7B4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{2150FA16-881F-46FA-9FC4-CC30937D5D47}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{BE6F4F08-366C-4965-81AC-3865DF63662D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{F446E3FD-F3A8-403E-AAE7-54B1E8F33D0C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{A0E16FC7-8BF9-402A-905B-B17C63CB8514}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{BE2E7268-93F3-45E1-902D-0A3C95208231}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{F9496202-F993-478D-BC05-EF9F1612A4AA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{3EFACC52-29E6-4D26-9084-41FB24F4DF8C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{919968DD-B5EE-49E6-A470-C693491890A3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{5AB113B0-2880-431C-9C05-F2276486FE8B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{7B7D4CD0-7391-4751-ADAD-3F8A6F713653}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{A2C07D6C-C962-4C0B-8FBE-8A9AAC52BDB3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{D9CC503D-0D05-49E2-86F3-38E11CC43353}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{E5860452-2EA3-47BD-9DEC-47FB23EF0602}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{FC3F491A-DCB2-4AA4-BE07-57A0DF685E2A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{8A329EBD-92A7-4E97-932C-A4EAB66138D0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{F78B829C-AF05-4ACA-BD6B-06CF7B0B42A0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{9B38589B-0CB1-4D23-846E-4209F670DBF1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{573C18D3-378A-4AF4-A7F6-1AFC50E8F4E7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{BDD1446A-CCBD-4024-B689-13F115AD4F24}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{30B7E726-577F-4B50-A347-200C3BA8EDB8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{EE671112-3CCF-415A-8FFC-C1C56AD5F75D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{7BD79BEA-0004-4BF9-B265-25765ABBABF7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{74F9398C-4439-4964-9E7D-43793298CB04}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{6EB53BD5-2BB5-4355-BD5A-AE16FD051A6C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{81EF137F-669E-4BF3-896C-68F0DB5252A8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{72D7498F-3D63-458F-A89D-B1E4B4A23A36}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{68A54F1D-639D-4194-B4D4-C9225327C57C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{C92400A5-0A26-422A-90CF-867B2AA0612B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{97E9BE8C-454E-493C-9157-A0FDCECADE17}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{BC08DDDE-3CE5-4749-A380-090384B72EA4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{5D32007E-6530-4859-9099-2114D5C89BA1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{7D00D786-BE55-4D20-91BF-35CC1C14D1B0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{91232223-A175-4212-A468-824F81BF2758}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{2F8BB31D-4804-4EC9-92E0-C45BDEF41495}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{481668CC-3F34-458C-9600-D7681470646F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{23F13FE3-0E27-4C26-BB99-31839CDFCB10}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{9F2CA8B0-EBFD-454B-92C3-1E97C9D9AC8C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{D8197848-A704-4E15-B3A7-CC1668B06C87}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{47D1A186-CD32-4D8C-99A1-CFE9C6EA77B8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{70AD9695-A694-44B4-89ED-D80FA0DD78A8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{30D472A0-3A41-4EAD-B845-1A8710C0C6C3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{7D2B0735-6F19-4D21-BFA5-00DBCD7DE5C8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{5E0DB207-7B70-4FDB-A69D-27D3A4D13938}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{F3AE1E05-51F3-45CD-9D27-FDECCCF46179}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{E0F6AF0C-B47C-40D9-844D-80F75718D60C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{8361787F-A559-4161-A4D9-1DAD97C18C5A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{D36E800B-2072-4816-8555-E7E1BB8F493B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{0BB77FB3-CCF0-4BF4-BED9-43D05B68F82A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{5D2AF306-A6A9-4805-9252-19ADC483AF91}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{B5598E30-84A6-4CDE-8409-05B57BD3E849}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{8CC024DD-383E-437E-B8F5-E8435A5B3960}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{F56683B1-4C69-41D7-9514-3D55CF97D8A3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{096638F9-E253-438A-A1C1-B246E4880D32}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{3A365FDB-968F-4571-830D-6F9C8ACD5E64}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{C540F07A-EB90-47C7-9E0E-0DD6DCD32298}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{2A1A8E3E-0866-4E23-B3C8-75D564E306B9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{CEADE86B-83C7-4463-AA40-AE951BCE5831}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{1ACC6392-284B-42E0-B525-B7B747D324CA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{8090CD0A-F65B-4C7B-AC8C-B5EDB6391058}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{6BCA824B-1E9D-4931-AA77-0B312EA28266}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{550D37BF-50B5-4E9D-AF10-C687CF43479F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{84B96515-43FA-4BD5-9A46-FCAF12D26714}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{BA1E5389-2545-4B01-8B15-F92AF4B60829}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{C97394FD-F1D6-4100-B194-0C107DD3D05E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{F96FABD8-9FBC-49CB-A3EC-D12DEC748305}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{AF9DA087-2F89-4492-B77B-020D00C75E06}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{DF731375-AD93-42D2-AB77-193CF6E7153C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{A6347E34-5D1A-4E4C-814A-3D79F72E21D4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{DA0DB14A-4254-4476-BEE3-9C9BE2D44C00}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{23CCEC53-D05C-41FD-AA66-018F6E99CB58}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{1625768E-C2DA-4DEB-9521-DAFDE75EA94B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{EBA56485-B763-4AE8-A3A9-2D73B91EDDBC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{63AB70E8-DB7E-4258-89E1-0B31C8DA008D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{B49100F6-6CCE-4712-8B63-7F8700B51C04}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "{E2F613F9-4110-48A5-B0E5-1592E185B961}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "", "langPack", "Captivate", "Adobe Captivate", "5")
INSERT INTO Payloads VALUES	("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "Captivate", "Adobe Captivate_AdobeCaptivate5fr_CALanguagePack", "5", "langPack")
INSERT INTO PayloadData VALUES("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "0" , "PayloadInfo", '<PayloadInfo version="3.0.116.0"><BuildInfo>
    <Property name="Created">2010-05-22 02:35:38.926000</Property>
    <Property name="TargetName">AdobeCaptivate5fr_CALanguagePack</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}</Property>
    <Property name="ProductName">Adobe Captivate fr_CA Language Pack</Property>
    <Property name="ProductVersion">5</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
  </InstallDir><Languages>
    <Language>fr_CA</Language>
  </Languages><Satisfies>
    <ProductInfo>
		<Family>Captivate</Family>
		<ProductName minVersion="5">Adobe Captivate_AdobeCaptivate5fr_CALanguagePack</ProductName>
	<ProductVersion>5</ProductVersion>
    </ProductInfo>
  </Satisfies><Conflicts>
    <AdobeCode>{12124FA1-4E8A-4361-AE42-6AB4348A30D7}</AdobeCode>
    <AdobeCode>{2DFEFC6B-081A-4EE8-B4EA-E36558EAB195}</AdobeCode>
    <AdobeCode>{ABE376E0-5E65-4103-A630-6CDD6B7BEBC7}</AdobeCode>
    <AdobeCode>{CB804F21-0528-48F2-A113-C2319F1C312A}</AdobeCode>
    <AdobeCode>{A922AED1-45C3-412C-8B1F-0A9CEFD262EA}</AdobeCode>
    <AdobeCode>{1DDE72E4-451D-4AAE-8119-F3A05AF8248D}</AdobeCode>
    <AdobeCode>{2915C5A0-6F99-4283-B337-A95D3B3537F4}</AdobeCode>
    <AdobeCode>{530A48C6-0001-40F4-8B3C-D5B11A77E4A3}</AdobeCode>
    <AdobeCode>{6E5DD161-2471-4A80-9BF0-32487B26A571}</AdobeCode>
    <AdobeCode>{AA25C36E-1F14-4A2F-84DB-2E2DFC628551}</AdobeCode>
    <AdobeCode>{13F58349-CEE0-4A6C-BF99-7D83C6D932BD}</AdobeCode>
    <AdobeCode>{E5568285-5BAA-450E-835C-DE5F73CDC12E}</AdobeCode>
    <AdobeCode>{4B00BE92-D639-4BD9-9D41-DB07E6EC7729}</AdobeCode>
    <AdobeCode>{45BA2C54-0554-41C3-9BC4-118307B298F4}</AdobeCode>
    <AdobeCode>{E3C511D1-C1D7-4AE7-8773-7972526A02CF}</AdobeCode>
    <AdobeCode>{C23B10F8-0252-4B06-B51C-A461453099B4}</AdobeCode>
    <AdobeCode>{CEB67C80-0E2D-4BB5-B71B-0896F7969A80}</AdobeCode>
    <AdobeCode>{3F1B6737-C6EF-4538-9975-0C6AFFA57568}</AdobeCode>
    <AdobeCode>{778C30EF-7CF5-487B-B02E-FBBB0D5295B0}</AdobeCode>
    <AdobeCode>{84EAF754-49D5-40DD-9A24-FB9C900AF9AA}</AdobeCode>
    <AdobeCode>{585E1940-DC01-4A00-BE80-052877C9B1F9}</AdobeCode>
    <AdobeCode>{0D599F3F-D6FB-40A7-AF38-C37124053C2B}</AdobeCode>
    <AdobeCode>{6DF7C4E1-F738-4CF6-BDEC-F0396D567569}</AdobeCode>
    <AdobeCode>{6C4D6D61-BBF9-4158-A444-9DB84904F421}</AdobeCode>
    <AdobeCode>{2E0CD670-38F1-4E8D-ADC7-AF4F2FD28943}</AdobeCode>
    <AdobeCode>{881FDC87-CDC2-4B4B-A60A-87C33AA55DC7}</AdobeCode>
    <AdobeCode>{DE6B0869-3EC9-4315-A530-152104E3154C}</AdobeCode>
    <AdobeCode>{E23EECB4-D0D1-4E79-BF35-E4552F01D277}</AdobeCode>
    <AdobeCode>{126E97A3-B947-4C6A-A001-52BB7BA6FA44}</AdobeCode>
    <AdobeCode>{D2B621B5-F4A9-4B0E-9215-5EA5D805B45F}</AdobeCode>
    <AdobeCode>{01FC8203-9B8C-472D-8124-13748166A0E1}</AdobeCode>
    <AdobeCode>{F18C6C29-DD8D-4497-9A09-EB139DB00F27}</AdobeCode>
    <AdobeCode>{64D7F2D8-96C4-4BEB-B59D-80B822A671F6}</AdobeCode>
    <AdobeCode>{8C1F51C9-88D4-4C90-8D17-5BE1DAA20DEA}</AdobeCode>
    <AdobeCode>{F4FEB12F-2FD2-467C-9E17-878FF2D5E382}</AdobeCode>
    <AdobeCode>{C1D2292E-FC66-4077-A007-70A89B2C8351}</AdobeCode>
    <AdobeCode>{051465B7-584B-4472-B9CA-22DE89226DB4}</AdobeCode>
    <AdobeCode>{C5B5A2A9-B3E9-475E-BEDE-BBA1C0849CFF}</AdobeCode>
    <AdobeCode>{913AF536-C121-49BA-8327-0D1C9A021084}</AdobeCode>
    <AdobeCode>{D48BB711-022F-4582-B6CE-26ABE82BE06C}</AdobeCode>
    <AdobeCode>{7833FE59-A4CE-48F6-8C17-6F3F499FCC70}</AdobeCode>
    <AdobeCode>{31DA4A96-0957-4665-AC56-084A14722D76}</AdobeCode>
    <AdobeCode>{9CB5202D-9D8C-43CB-BAC1-9BB4BA20DCD6}</AdobeCode>
    <AdobeCode>{0DF48421-4856-4A43-81AE-0538FFE69F79}</AdobeCode>
    <AdobeCode>{37F92876-C37F-498D-8FA3-DC0B76F94B30}</AdobeCode>
    <AdobeCode>{4E5965D6-6BD6-4BAF-82B2-160EC33BF5B3}</AdobeCode>
    <AdobeCode>{01560070-6068-4321-B538-AC2C88BF0636}</AdobeCode>
    <AdobeCode>{D068409D-E84D-41B8-B28A-250BFF063DD7}</AdobeCode>
    <AdobeCode>{8574A897-852F-4754-8712-9C4F0238A19C}</AdobeCode>
    <AdobeCode>{342082E8-8C65-4050-B7C2-F7E1766262AC}</AdobeCode>
    <AdobeCode>{74847CFB-C26A-45C9-956A-605D842DB979}</AdobeCode>
    <AdobeCode>{DD8490D3-DA21-4A3B-8907-FDB7CB503FF6}</AdobeCode>
    <AdobeCode>{F1863A83-E88B-48A5-B78B-9163EACD82D7}</AdobeCode>
    <AdobeCode>{17EA2DE7-EE60-4919-8E7B-4C47C29B3D54}</AdobeCode>
    <AdobeCode>{A29F1047-A78F-4E81-9346-C6259AA88E0E}</AdobeCode>
    <AdobeCode>{0686798C-B809-41B6-AEA4-7F34B942ABA6}</AdobeCode>
    <AdobeCode>{E4956CE0-E963-45A1-A9BE-ED83A40BFF04}</AdobeCode>
    <AdobeCode>{4EAF84AE-FF1E-422B-B445-32C9D0E2610B}</AdobeCode>
    <AdobeCode>{9F80AA4F-9008-4B86-B48D-1537E0EAD7FF}</AdobeCode>
    <AdobeCode>{466AF8CD-AF19-441E-AA3F-038CFEB6FA4C}</AdobeCode>
    <AdobeCode>{11CCD0DD-B99E-444E-BF90-FA4A7DAAD6CB}</AdobeCode>
    <AdobeCode>{4A87DCA1-2286-4939-B405-B681C4F26E5F}</AdobeCode>
    <AdobeCode>{880E3CC1-712B-4D2B-9A69-5E898376C53D}</AdobeCode>
    <AdobeCode>{C12EF598-309F-4186-8BEA-56479AB044C7}</AdobeCode>
    <AdobeCode>{3047B555-2E02-4226-B958-CFFA4CF98B15}</AdobeCode>
    <AdobeCode>{A9C1412D-F768-4CB7-9601-A2E68487924B}</AdobeCode>
    <AdobeCode>{46D0F063-D567-453E-8924-A921B04DB3E4}</AdobeCode>
    <AdobeCode>{C629338E-027D-44F6-B5D5-B2C6A7C5FC32}</AdobeCode>
    <AdobeCode>{BCDC981B-7F0F-4B86-A264-CEF5B661FE95}</AdobeCode>
    <AdobeCode>{08ABF332-9A8C-4C71-B507-3D73F6A5E87D}</AdobeCode>
    <AdobeCode>{6BBB6C3E-40F8-4D7A-9181-269BCFEAFE09}</AdobeCode>
    <AdobeCode>{30D82E87-59F8-4D7F-A06C-82BF3CD27A50}</AdobeCode>
    <AdobeCode>{B2D923D5-10E3-4C4E-B0E2-750EEF81E034}</AdobeCode>
    <AdobeCode>{A66EBACD-CD7F-4FFF-8BDD-E2BB2E050F88}</AdobeCode>
    <AdobeCode>{C5D26BF7-2D38-4740-84E5-68754B36C41C}</AdobeCode>
    <AdobeCode>{1180A264-930C-4B65-AAAF-93B880BF1DB5}</AdobeCode>
    <AdobeCode>{63BA874F-4A39-40D4-8ECF-203E65532DA1}</AdobeCode>
    <AdobeCode>{0B71735B-67C1-49BF-8088-479AACF22526}</AdobeCode>
    <AdobeCode>{96A119B4-7440-49F4-8920-2563D341FC7B}</AdobeCode>
    <AdobeCode>{F609B21F-A096-4EBC-8F43-93969541E7B4}</AdobeCode>
    <AdobeCode>{2150FA16-881F-46FA-9FC4-CC30937D5D47}</AdobeCode>
    <AdobeCode>{BE6F4F08-366C-4965-81AC-3865DF63662D}</AdobeCode>
    <AdobeCode>{F446E3FD-F3A8-403E-AAE7-54B1E8F33D0C}</AdobeCode>
    <AdobeCode>{A0E16FC7-8BF9-402A-905B-B17C63CB8514}</AdobeCode>
    <AdobeCode>{BE2E7268-93F3-45E1-902D-0A3C95208231}</AdobeCode>
    <AdobeCode>{F9496202-F993-478D-BC05-EF9F1612A4AA}</AdobeCode>
    <AdobeCode>{3EFACC52-29E6-4D26-9084-41FB24F4DF8C}</AdobeCode>
    <AdobeCode>{919968DD-B5EE-49E6-A470-C693491890A3}</AdobeCode>
    <AdobeCode>{5AB113B0-2880-431C-9C05-F2276486FE8B}</AdobeCode>
    <AdobeCode>{7B7D4CD0-7391-4751-ADAD-3F8A6F713653}</AdobeCode>
    <AdobeCode>{A2C07D6C-C962-4C0B-8FBE-8A9AAC52BDB3}</AdobeCode>
    <AdobeCode>{D9CC503D-0D05-49E2-86F3-38E11CC43353}</AdobeCode>
    <AdobeCode>{E5860452-2EA3-47BD-9DEC-47FB23EF0602}</AdobeCode>
    <AdobeCode>{FC3F491A-DCB2-4AA4-BE07-57A0DF685E2A}</AdobeCode>
    <AdobeCode>{8A329EBD-92A7-4E97-932C-A4EAB66138D0}</AdobeCode>
    <AdobeCode>{F78B829C-AF05-4ACA-BD6B-06CF7B0B42A0}</AdobeCode>
    <AdobeCode>{9B38589B-0CB1-4D23-846E-4209F670DBF1}</AdobeCode>
    <AdobeCode>{573C18D3-378A-4AF4-A7F6-1AFC50E8F4E7}</AdobeCode>
    <AdobeCode>{BDD1446A-CCBD-4024-B689-13F115AD4F24}</AdobeCode>
    <AdobeCode>{30B7E726-577F-4B50-A347-200C3BA8EDB8}</AdobeCode>
    <AdobeCode>{EE671112-3CCF-415A-8FFC-C1C56AD5F75D}</AdobeCode>
    <AdobeCode>{7BD79BEA-0004-4BF9-B265-25765ABBABF7}</AdobeCode>
    <AdobeCode>{74F9398C-4439-4964-9E7D-43793298CB04}</AdobeCode>
    <AdobeCode>{6EB53BD5-2BB5-4355-BD5A-AE16FD051A6C}</AdobeCode>
    <AdobeCode>{81EF137F-669E-4BF3-896C-68F0DB5252A8}</AdobeCode>
    <AdobeCode>{72D7498F-3D63-458F-A89D-B1E4B4A23A36}</AdobeCode>
    <AdobeCode>{68A54F1D-639D-4194-B4D4-C9225327C57C}</AdobeCode>
    <AdobeCode>{C92400A5-0A26-422A-90CF-867B2AA0612B}</AdobeCode>
    <AdobeCode>{97E9BE8C-454E-493C-9157-A0FDCECADE17}</AdobeCode>
    <AdobeCode>{BC08DDDE-3CE5-4749-A380-090384B72EA4}</AdobeCode>
    <AdobeCode>{5D32007E-6530-4859-9099-2114D5C89BA1}</AdobeCode>
    <AdobeCode>{7D00D786-BE55-4D20-91BF-35CC1C14D1B0}</AdobeCode>
    <AdobeCode>{91232223-A175-4212-A468-824F81BF2758}</AdobeCode>
    <AdobeCode>{2F8BB31D-4804-4EC9-92E0-C45BDEF41495}</AdobeCode>
    <AdobeCode>{481668CC-3F34-458C-9600-D7681470646F}</AdobeCode>
    <AdobeCode>{23F13FE3-0E27-4C26-BB99-31839CDFCB10}</AdobeCode>
    <AdobeCode>{9F2CA8B0-EBFD-454B-92C3-1E97C9D9AC8C}</AdobeCode>
    <AdobeCode>{D8197848-A704-4E15-B3A7-CC1668B06C87}</AdobeCode>
    <AdobeCode>{47D1A186-CD32-4D8C-99A1-CFE9C6EA77B8}</AdobeCode>
    <AdobeCode>{70AD9695-A694-44B4-89ED-D80FA0DD78A8}</AdobeCode>
    <AdobeCode>{30D472A0-3A41-4EAD-B845-1A8710C0C6C3}</AdobeCode>
    <AdobeCode>{7D2B0735-6F19-4D21-BFA5-00DBCD7DE5C8}</AdobeCode>
    <AdobeCode>{5E0DB207-7B70-4FDB-A69D-27D3A4D13938}</AdobeCode>
    <AdobeCode>{F3AE1E05-51F3-45CD-9D27-FDECCCF46179}</AdobeCode>
    <AdobeCode>{E0F6AF0C-B47C-40D9-844D-80F75718D60C}</AdobeCode>
    <AdobeCode>{8361787F-A559-4161-A4D9-1DAD97C18C5A}</AdobeCode>
    <AdobeCode>{D36E800B-2072-4816-8555-E7E1BB8F493B}</AdobeCode>
    <AdobeCode>{0BB77FB3-CCF0-4BF4-BED9-43D05B68F82A}</AdobeCode>
    <AdobeCode>{5D2AF306-A6A9-4805-9252-19ADC483AF91}</AdobeCode>
    <AdobeCode>{B5598E30-84A6-4CDE-8409-05B57BD3E849}</AdobeCode>
    <AdobeCode>{8CC024DD-383E-437E-B8F5-E8435A5B3960}</AdobeCode>
    <AdobeCode>{F56683B1-4C69-41D7-9514-3D55CF97D8A3}</AdobeCode>
    <AdobeCode>{096638F9-E253-438A-A1C1-B246E4880D32}</AdobeCode>
    <AdobeCode>{3A365FDB-968F-4571-830D-6F9C8ACD5E64}</AdobeCode>
    <AdobeCode>{C540F07A-EB90-47C7-9E0E-0DD6DCD32298}</AdobeCode>
    <AdobeCode>{2A1A8E3E-0866-4E23-B3C8-75D564E306B9}</AdobeCode>
    <AdobeCode>{CEADE86B-83C7-4463-AA40-AE951BCE5831}</AdobeCode>
    <AdobeCode>{1ACC6392-284B-42E0-B525-B7B747D324CA}</AdobeCode>
    <AdobeCode>{8090CD0A-F65B-4C7B-AC8C-B5EDB6391058}</AdobeCode>
    <AdobeCode>{6BCA824B-1E9D-4931-AA77-0B312EA28266}</AdobeCode>
    <AdobeCode>{550D37BF-50B5-4E9D-AF10-C687CF43479F}</AdobeCode>
    <AdobeCode>{84B96515-43FA-4BD5-9A46-FCAF12D26714}</AdobeCode>
    <AdobeCode>{BA1E5389-2545-4B01-8B15-F92AF4B60829}</AdobeCode>
    <AdobeCode>{C97394FD-F1D6-4100-B194-0C107DD3D05E}</AdobeCode>
    <AdobeCode>{F96FABD8-9FBC-49CB-A3EC-D12DEC748305}</AdobeCode>
    <AdobeCode>{AF9DA087-2F89-4492-B77B-020D00C75E06}</AdobeCode>
    <AdobeCode>{DF731375-AD93-42D2-AB77-193CF6E7153C}</AdobeCode>
    <AdobeCode>{A6347E34-5D1A-4E4C-814A-3D79F72E21D4}</AdobeCode>
    <AdobeCode>{DA0DB14A-4254-4476-BEE3-9C9BE2D44C00}</AdobeCode>
    <AdobeCode>{23CCEC53-D05C-41FD-AA66-018F6E99CB58}</AdobeCode>
    <AdobeCode>{1625768E-C2DA-4DEB-9521-DAFDE75EA94B}</AdobeCode>
    <AdobeCode>{EBA56485-B763-4AE8-A3A9-2D73B91EDDBC}</AdobeCode>
    <AdobeCode>{63AB70E8-DB7E-4258-89E1-0B31C8DA008D}</AdobeCode>
    <AdobeCode>{B49100F6-6CCE-4712-8B63-7F8700B51C04}</AdobeCode>
    <AdobeCode>{E2F613F9-4110-48A5-B0E5-1592E185B961}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeCaptivate5fr_CALanguagePack">
    <DisplayName>Adobe Captivate fr_CA Language Pack</DisplayName>
  </Channel><Extends type="langPack">
    <ParentProductInfo minVersion="5">
					<Family>Captivate</Family>
					<ProductName>Adobe Captivate</ProductName>
				</ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="5304859" sysDriveSize="314"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>5304859</TotalSize>
      <MaxPathComponent>/Adobe Captivate 5/fr_CA/Gallery/Preloaders/AS3\hand cursor loading.fla</MaxPathComponent>
    </Destination>
    <Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>314</TotalSize>
      <MaxPathComponent>/HelpCfg/fr_FR\Captivate_5.0.helpcfg</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="314"/>
      <Asset flag="1" name="Assets1_1" size="5304859"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="fr_CA">5</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="fr_CA">Adobe Captivate fr_CA Language Pack</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "0", "ChannelID", "AdobeCaptivate5fr_CALanguagePack")
INSERT INTO PayloadData VALUES("{DE8A7F54-8DFB-4BF7-807C-5BA6ED268505}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeCaptivate5fr_CALanguagePack">
    <DisplayName>Adobe Captivate fr_CA Language Pack</DisplayName>
  </Channel>')
